package jcircus.util;

/**
 * Generates IdProcess.
 *
 * @author Angela Freitas
 */
public class IdCircusProcessGenerator {

    private int id = 0;
    
    // (singleton pattern)
    private static IdCircusProcessGenerator generator;
    
    public static IdCircusProcessGenerator getGenerator() {
        
        if (generator == null) generator = new IdCircusProcessGenerator();
        return generator;
    }

    public IdCircusProcessGenerator() {
    }
    
    public int getNextId() {
        int r = this.id;
        this.id++;
        return r;
    }
    
}
